document.addEventListener("alpine:init", () => {
  Alpine.data("allproduks", () => ({
    items: [
      {
        id: 1,
        name: "Gemez Enaak Spicy Duplex",
        allprod: "1.png",
        price: 25000,
      },
      { id: 2, name: "My Chocho", allprod: "2.jpg", price: 20000 },
      { id: 3, name: "Spix Soba Chicken", allprod: "3.jpg", price: 15000 },
      {
        id: 4,
        name: "Gemez Enaak Spicy Polybag",
        allprod: "4.png",
        price: 10000,
      },
      { id: 5, name: "Suki Stick Kecap", allprod: "5.jpg", price: 5000 },
      { id: 6, name: "Tic-Tic Bawang", allprod: "6.jpg", price: 2500 },
    ],
  }));


Alpine.store('cart',{
  items: [],
  total: 0, 
  quantity: 0,
  add(newItem) {

    //opo ono barang sing podo ning keranjang ?
    const cartItem = this.items.find((item) => item.id === newItem.id);
    //bek menowo durung enek brarti kosong
    if(!cartItem){
      this.items.push({...newItem, quantity: 1, total: newItem.price });
      this.quantity++;
      this.total += newItem.price;
      
    } else{
      //cek ulang barang ono opo ora ning keranjang
      this.items = this.items.map((item)=> {
        //Bek menowo barang bedo otomatis item nambah jenis item e
        if(item.id !== newItem.id){
          return item;
        } else{
          //Tapi nek barang uwis ono maka ketambah qty, uduk jenis item e
          item.quantity++;
          item.total = item.price * item.quantity;
          this.quantity++;
          this.total += item.price;
          return item;
        }
      });
    }
  },
  remove(id){
    //kurangi item sing ape ditumbas
    const cartItem = this.items.find((item) => item.id === id);
    //iso dikurangi pokok lebih dari 1
    if(cartItem.quantity > 1){
      //telusuri siji siji
      this.items = this.items.map((item) => {
        //jika bukan barang yang di klik maka skip
        if(item.id !== id){
          return item;
        } else {
          item.quantity--;
          item.total = item.price * item.quantity;
          this.quantity--;
          this.total -= item.price;
          return item;
        }
      })
    } else if (cartItem.quantity === 1){
      //jika barang 1 maka bisa di hapus (kalo dikurangi tidak bisa)
      this.items = this.items.filter((item) => item.id !== id);
      this.quantity--;
      this.total-= cartItem.price;
    }
  },
});
});

// Form Validasi
const checkoutButton = document.querySelector('.checkout-button');
checkoutButton.disabled = true;

const form = document.querySelector('#checkoutForm');

form.addEventListener('keyup', function() {
for (let i = 0; i < form.elements.length; i++){
  if (form.elements[i].value.length !== 0){
    checkoutButton.classList.remove('disabled');
    checkoutButton.classList.add('disabled');
  } else {
    return false;
  }
}
checkoutButton.disabled = false;
checkoutButton.classList.remove('disabled');
});


//kirim data ketika tombol cekout di klik
checkoutButton.addEventListener('click', async function (e) {
e.preventDefault();
const formData = new FormData(form);
const data = new URLSearchParams(formData);
const objData = Object.fromEntries(data);
// const message = formatMessage(objData);
// window.open('http://wa.me/6289529778094?text=' + encodeURIComponent(message))

// Minta transaksi token menggunakan ajax / fetch
try {
  const response = await fetch('php/placeOrder.php', {
    method: 'POST',
    body: data,
  });
  const token = await response.text(); 
  //console.log(token);
  window.snap.pay(token);
} catch (err) {
  console.log(err.message);
}
});
//pesan whatsapp
const formatMessage = (obj) =>{
  return `Data Customer
  Nama: ${obj.name}
  Email: ${obj.email}
  No HP: ${obj.phone}
  
  Data Pesanan
  ${JSON.parse(obj.items).map((item) => `${item.name}(${item.quantity} x ${rupiah(item.total)}) \n`)}
TOTAL: ${rupiah(obj.total)}
TERIMA KASIH.`;
};

// konversi ke rupiah
const rupiah = (number) => {
  return new Intl.NumberFormat('id-ID', {
    style: 'currency', 
    currency: 'IDR',
    minimumFractionDigits: 0
  }).format(number);
};


// Form Validasi
const checkoutButton = document.querySelector('.checkout-button');
checkoutButton.disabled = true;

const form = document.querySelector('#checkoutForm');

form.addEventListener('keyup', function() {
for (let i = 0; i < form.elements.length; i++){
  if (form.elements[i].value.length !== 0){
    checkoutButton.classList.remove('disabled');
    checkoutButton.classList.add('disabled');
  } else {
    return false;
  }
}
checkoutButton.disabled = false;
checkoutButton.classList.remove('disabled');
});